TITLE 									{ exa071.pde }
   'Metal Rod in a Box'
SELECT    								{ Student Edition }
   errlim=1e-3     spectral_colors
VARIABLES
   U
DEFINITIONS
   L=1	    r0=0.3     U_rod=1.0
   Ex=-dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
EQUATIONS
   div( grad( U))=0						
BOUNDARIES
region 'domain'	
   start 'box' (-L,-L)  value( U)= 0				{ Metal box }
   line to (L,-L)  to (L,L)  to (-L,L)  close
   start 'rod' (r0,0) 						{ Cutout for rod }
   value(U)=U_rod   arc( center=0,0) angle=360  	
PLOTS
   contour( U)     surface( U)	
   elevation( U) on 'box' range(-0.0001,0.0001)	   { Plot range for U }
   elevation( U) on 'rod' range(0.999,1.001)	
   contour( Em)     elevation( Em) on 'box'     vector( E) norm
END


